
(function(){
    var apiUrl = '/webapi/';
    var rely = [templateDir+'/static/vue/js/vue2.5.17.js','/ks_inc/static/js/vue.main.js?'+hash,templateDir+'/static/vue-router/js/vue-router.js',templateDir+'/static/swiper/js/swiper.min.js',templateDir+'/static/swiper/js/vue-awesome-swiper.js'];

    loadFile()
    /**
     * 加载文件
     */
    function loadFile(index){
        index = index || 0;
        var script = document.createElement('script');
        script.src = rely[index];
        document.getElementsByTagName('body')[0].appendChild(script);
        script.onload = function(){
            this.outerHTML = null;
            index++;
            if(index >= rely.length){
                loadFileSuccess()
            }else{
                loadFile(index)
            }
        }
    }
    
    function loadFileSuccess(){
        new KS_Main();
        /**
         * 创建路由
         */
        var routes = [
            /**
             * 首页
             */
            {
                path:"/",
                component:{
                    data:function(){
                        return {
                            courseTab:0,
                            bodyWidth:null,
                            searchText:'',
                            courseHeight:null,
                            teacherHeight:null,
                            swiperOptionA: {
                                autoplay:true,
                                pagination: {
                                    el: '.swiper-pagination'
                                }
                            },
                            swiperOptionB: {
                                slidesPerView:1.1
                            },
                            swiperOptionC: {
                                slidesPerView:2.5
                            },
                            swiperOptionD:{
                                slidesPerView:4.5
                            },
                            nav:indexNavList
                        }
                    },
                    mounted:function(){
                        var that = this;
                        this.setHeight();
                        window.addEventListener('resize',function(){
                            that.setHeight()
                        });
                        
                       
                    },
                    methods:{
                        setHeight:function(){
                            this.bodyWidth = body.offsetWidth;
                            this.courseHeight = (this.bodyWidth - 45) / 2 * 0.6;
                            this.teacherHeight = (this.bodyWidth - 35) / 2.5;
                           
                        },
                        gosearch:function(e){
                            /**
                             * 触发enter键
                             */
                            if(e.keyCode === 13){
                                if(this.searchText.replace(/\s+/,'')){
                                    var searchUrl = URL_search.value;
                                    if(searchUrl.indexOf('?')!==-1){
                                        searchUrl += '&key='+this.searchText
                                    }else{
                                        searchUrl += '?key='+this.searchText
                                    }
                                    location.href = searchUrl
                                }else{
                                    this.searchText = ''
                                }
                                
                            }
                        },
                        open:function(url){
                            location.href = url;
                        },
                        setPrice:function(price){
                          return price === '0.00' ? '免费' : '¥'+price
                        },
                        getLiveState:function(state){
                            return (state == 0 && '直播未开始') || (state == 1 && '正在直播中') || (state == 2 && '直播已结束')
                        }
                    },
                    template:"#index"
                }
            },
            
            /**
             * 发现
             */
            {
                path:"/find",
                component:{
                    data:function(){
                        return {
                            tab:null,
                            loading:true,
                            classImageHeight:null,
                            filterTab:{
                                sort:false,
                                category:false,
                                other:false
                            },
                            requested:false,
                            /**
                             * 排序
                             */
                            sort:0,
                            sortList:[],
                            /**
                             * 价格
                             */
                            price:0,
                            priceList:[],
                            classid:0,
                            className:'分类',
                            firstid:0,
                            firstName:null,
                            secondid:null,
                            secondName:null,
                            thirdid:null,
                            firstCategory:[],
                            secondCategory:[],
                            thirdCategory:[],
                            pageCount:1,
                            page:1,
                            pagesize:10,
                            list:[],
                            /**
                             * 点播课程
                             */
                            course:{
                                requested:false,
                                teachway:0,
                                teachwayList:[
                                    {
                                        name:'全部',
                                        key:0
                                    },
                                    {
                                        name:'点播课程',
                                        key:1
                                    },
                                    {
                                        name:'直播课程',
                                        key:5
                                    },
                                    {
                                        name:'抢购课程',
                                        key:101
                                    },
                                    {
                                        name:'团购课程',
                                        key:102
                                    },
                                    {
                                        name:'积分兑换',
                                        key:103
                                    },
                                    {
                                        name:'课程套餐',
                                        key:3
                                    }
                                ],
                                
                            },
                            face:{
                                requested:false
                            },
                            classroom:{
                                current:null,
                                orderfield:'addtime asc',
                                list:[
                                    {
                                        name:'最新',
                                        key:'addtime asc'
                                    },
                                    {
                                        name:'最热',
                                        key:'lookcount desc'
                                    },
                                    {
                                        name:'课程数',
                                        key:'coursecount desc'
                                    },
                                    {
                                        name:'综合评分',
                                        key:'score asc'
                                    }
                                ]
                            }
                        }
                    },
                    watch:{
                        '$route.query':function(data){
                            
                            if(data.tab != this.tab){
                                this.slideTab();
                            }
                            this.update()
                        }

                    },
                    methods:{
                        
                        /**
                         * 路由传参
                         */
                        go:function(key,v){
                            var that = this;
                            if(key === 'tab' && v != this.tab){ 
                                this.$router.push({
                                    path: '/find',
                                    query: {
                                        tab:v
                                    }
                                })
                            }else{
                                var queryData = JSON.parse(JSON.stringify(this.$route.query));
                                queryData[key] = v;
                                this.$router.push({
                                    path: '/find',
                                    query: queryData
                                });
                            }
                            domap(Object.keys(this.filterTab),function(key){
                                that.filterTab[key] = false
                            })

                        },
                        open:function(url){
                            location.href = url
                        },
                        /**
                         * 切换选项卡
                         * 0 课程  1面授 2套餐 3班级
                         */
                        slideTab:function(){
                            this.classid = 0;
                            this.sort = 0;
                            this.className = '分类';
                            this.firstid = 0;
                            this.firstName = null;
                            this.secondid = null;
                            this.secondName = null;
                            this.thirdid = null;
                            this.secondCategory = [];
                            this.thirdCategory = [];
                            this.pageCount = 1;
                            this.requested = false;
                            this.tab = Number(this.$route.query.tab || 0);
                            
                        },
                        update:function(){
                            this.list = [];
                            this.page = 1;
                            this.show()
                        },
                        selectOption:function(key,v){
                            if(key === 'teachway'){
                                this.course[key] = v;
                            }else{
                                this[key] = v;
                            }
                        },
                        filterDetermine:function(){
                            this.go('price',this.price);
                            this.go('teachway',this.course.teachway)
                        },
                        /**
                         * 页面显示，初次渲染
                         */
                        show:function(){
                            
                            this.loading = true;
                            var that = this;
                            var parameter = this.$route.query;
                            this.price = parameter.price || 0;
                            this.sort = parameter.sort || 0;
                            this.classid = parameter.classid || 0;
                            this.classroom.orderfield = parameter.orderfield || 'addtime asc';
                            if(!this.requested){
                                /**
                                 * 请求排序项
                                 */
                                request(apiUrl+'Course/GetFilterSort?from=m',null,function(res){
                                    domap(res.data,function(item){
                                        switch(item.name){
                                            case 'sort':
                                                that.sortList = item.list
                                                break
                                            case 'price':
                                                that.priceList = [
                                                    {
                                                        name:'不限',
                                                        key:0
                                                    },
                                                    {
                                                        name:'免费',
                                                        key:100
                                                    }
                                                ].concat(item.list)
                                                break
                                        }
                                    })
                                    
                                },'json');
                            }

                            var costype = this.tab == 1 ? 1 : 0;
                            /**
                             * 请求分类
                             * 点播与班级分类为同一张表
                             */
                            if(!this.requested){
                                request(apiUrl+'Course/GetCourseClass?from=m&costype='+costype,null,function(res){
                                    that.firstCategory = res.data;
                                    var classid = that.classid;
                                    /**
                                     * 首次进入，设置选中分类状态
                                     */
                                    if(classid != 0 && !that.requested){
                                        that.setCurrentClassInfo({
                                            list:res.data
                                        },classid,1)
                                    }
                                    that.requested = true;
                                },'json')
                            }
                            if(this.tab == 0 || this.tab == 1){
                                
                                var action = (this.tab == 0 && 'GetVodList') || (this.tab == 1 && 'GetFaceList');
                                var teachway = '';
                                if(this.tab == 0){
                                    this.course.teachway = parameter.teachway || 0;
                                    teachway = '&teachway='+this.course.teachway
                                }
                                request(apiUrl+'Course/'+action+'?from=m&classid='+this.classid+'&sort='+this.sort+teachway+'&price='+this.price+'&pagesize='+this.pagesize+'&page='+this.page,null,function(res){
                                    that.pageCount = Number(res.pageCount);
                                    that.list = that.list.concat(res.data);
                                    that.$nextTick(function(){
                                        that.loading = false
                                    })
                                },'json')
                                
                            }else if(this.tab == 2){
                                request(apiUrl+'ClassRoom/GetClassRoomList?from=m&classid='+this.classid+'&orderfield='+this.classroom.orderfield+'&pagesize='+this.pagesize+'&page='+this.page,null,function(res){
                                    domap(that.classroom.list,function(item,i){
                                        if(item.key === that.classroom.orderfield){
                                            that.classroom.current = i
                                        }
                                    })
                                    that.pageCount = Number(res.pageCount);
                                    that.list = that.list.concat(res.data);
                                    that.$nextTick(function(){
                                        that.loading = false
                                    })
                                },'json')
                                
                            }
                            
                        },
                        setCurrentClassInfo:function(data,classid,level){
    
                            for(var i=0;i<data.list.length;i++){
                                var item = data.list[i];
                               
                                if(item.classId == classid){
                                    if(level === 1){
                                        this.firstid = item.classId;
                                        this.firstName = item.className;
                                        this.className = item.className;
                                        if(item.childs){
                                            this.secondCategory = item.childs;
                                            this.secondid = item.classId
                                        }
                                    }else if(level == 2){
                                        this.firstid = data.parentid1;
                                        this.firstName = data.parentName1;
                                        this.secondCategory = data.list;
                                        this.secondid = item.classId;
                                        this.secondName = item.className;
                                        this.className = item.className;
                                        if(item.childs){
                                            this.thirdCategory = item.childs;
                                            this.thirdid = item.classId
                                        }
                                    }else if(level == 3){
                                        this.firstid = data.parentid1;
                                        this.firstName = data.parentName1;
                                        this.secondCategory = data.childs1;    
                                        this.secondid = data.parentid2;
                                        this.secondName = data.parentName2;
                                        this.thirdCategory = data.list;    
                                        this.thirdid = item.classId;
                                        this.className = item.className;
                                    } 
                                    break
                                }else if(item.childs){
                                    /**
                                     * 最暴力的方法复制一个对象
                                     */
                                    var newData = JSON.parse(JSON.stringify(data));
                                    newData['parentid'+level] = item.classId;
                                    newData['parentName'+level] = item.className;
                                    newData['childs'+level] = item.childs ? item.childs : [];
                                    newData.list = item.childs;
                                    this.setCurrentClassInfo(newData,classid,level+1)
                                }
                            }
                        },
                        /**
                         * 滚动监听
                         */
                        scroll:function(){
                            var isScrolltolower = getIsScrolltolower(body);
                            if(isScrolltolower){
                                if(this.page < this.pageCount && !this.loading){
                                    this.page++;
                                    this.show();
                                }
                            }
                        },
                        /**
                         * 打开筛选层
                         */
                        openFilterBox:function(v){
                            var that = this;
                            domap(Object.keys(this.filterTab),function(key){
                                if(key != v){
                                    that.filterTab[key] = false
                                }
                            })
                            this.filterTab[v] = this.filterTab[v] ? false : true;
                            
                        },
                        /**
                         * 筛选分类
                         */
                        filterClass:function(level,item){
                            switch(level){
                                case 1:
                                    this.firstid = item.classId;
                                    this.firstName = item.className;
                                    this.secondid = null;
                                    this.thirdid = null;
                                    this.secondCategory = [];
                                    this.thirdCategory = [];
                                    if(item.childs){
                                        this.secondCategory = item.childs;
                                    }
                                    break
                                case 2:
                                    this.secondid = item.classId;
                                    this.secondName = item.className;
                                    this.thirdid = null;
                                    this.thirdCategory = [];
                                    if(item.childs){
                                        this.thirdCategory = item.childs
                                    }
                                    break
                                case 3:
                                    this.thirdid = item.classId;
                                    break
                            }
                            /**
                             * 执行筛选
                             */
                            if(!item.childs || level === 3){
                                this.classid = item.classId;
                                this.className = item.className;
                                this.go('classid',item.classId)
                            }
                            
                        },
                        
                        /**
                         * 触发遮罩层
                         */
                        maskTrigger:function(){
                            this.filterTab.sort = false;
                            this.filterTab.category = false;
                            this.filterTab.other = false;
                        },
                        /**
                         * 高度设置
                         */
                        setHeight:function(){
                            this.classImageHeight = (body.offsetWidth - 20) * 0.6
                        }
                    },
                    mounted:function(){
                        var that = this;
                        this.slideTab();
                        this.show();
                        this.setHeight();
                        window.addEventListener('resize',function(){
                            that.setHeight()
                        });
                        window.addEventListener('scroll',function(){
                            that.scroll()
                        });
                    },
                    template:"#find"
                }
            },
            {
                path:"/community",
                component:{
                    data:function(){
                        return {
                            pageHeight:null,
                            swiperOption: {
                                slidesPerView:1.1
                            },
                            tab:0,
                            loaded:false,
                            page:1,
                            pageCount:1,
                            loading:false,
                            list:[]
                        }
                    },
                    watch:{
                        '$route.query.tab':function(v){
                            this.tab = v;
                            this.loaded = false;
                            this.page = 1;
                            this.pageCount = 1;
                            this.list = [];
                            this.getList()
                        },
                    },
                    mounted:function(){
                        var that = this;
                        this.tab = this.$route.query.tab || 0;
                      
                        this.getList();
                        window.addEventListener('scroll',function(){
                            that.scroll()
                        });
                    },
                    methods:{
                        go:function(key,v){
                            var queryData = JSON.parse(JSON.stringify(this.$route.query));
                            queryData[key] = v;
                            this.$router.push({
                                path: '/community',
                                query: queryData
                            });
                        },
                        getList:function(){
                            this.loading = true;
                            var that = this;
                            var hot = this.tab == 1 ? '&do=hot' : '';
                            request(apiUrl+'Groups/GetTopicList?from=m'+hot+'&page='+this.page,null,function(res){
                                
                                domap(res.data,function(item){
                                    item.Annex = item.Annex ? item.Annex.split('§') : [];
                                    if(item.Content){
                                        /**
                                         * 正则匹配表情
                                         */
                                        var moods = item.Content.match(/\[[\u4e00-\u9fa5]+\]/g) || [];
                                       
                                        domap(moods,function(v){
                                            var name = v.match(/[\u4e00-\u9fa5]+/)[0];
                                            item.Content = item.Content.replace(v,'<img src="/sysimg/clubemot/'+name+'.gif" />')

                                        })
                                    }
                                });
                                that.list = that.list.concat(res.data);
                                that.pageCount = res.pageCount;
                                that.loading = false;
                                that.loaded = true;
                                
                            },'json')
                        },
                        open:function(url){
                            location.href = url
                        },
                        /**
                         * 滚动监听
                         */
                        scroll:function(){
                            var isScrolltolower = getIsScrolltolower(body)
                            if(isScrolltolower){
                                if(this.page < this.pageCount && !this.loading){
                                    this.page++;
                                    this.getList();
                                }
                            }
                        }
                    },
                    activated:function(){
                        this.tab = this.$route.query.tab || 0;
                    },
                    template:"#community"
                }
            }
        ];
        
        var router = new VueRouter({
            routes
        });

        Vue.use(VueAwesomeSwiper)
        new Vue({
            el:"#app",
            data:{
            },
            mounted: function(){
                loading.style.display = 'none';
                
            },
            methods:{
                open:function(url){
                    location.href = url
                },
                goUser:function(userIndex){
                    getUserInfo(function(res){
                        location.href = userIndex
                    },function(res){
                        location.href = res.url_login
                    })
                }
            },
            router
        });

    }

})();